/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.entity.base;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationProcessor;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.BaseCreeper;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.CreeperType;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.WaterCreeperMoveControl;
import tech.thatgravyboat.creeperoverhaul.common.utils.AnimationConstants;

public class WaterCreeper
extends BaseCreeper {
    public WaterCreeper(EntityType<? extends Creeper> entityType, Level level, CreeperType type) {
        super(entityType, level, type);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new WaterCreeperMoveControl(this);
    }

    public boolean checkSpawnObstruction(LevelReader levelReader) {
        return levelReader.isUnobstructed((Entity)this);
    }

    @Override
    protected void registerMovementGoals() {
        this.goalSelector.addGoal(5, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public void baseTick() {
        int i = this.getAirSupply();
        super.baseTick();
        if (this.isAlive() && !this.isInWaterOrBubble()) {
            this.setAirSupply(i - 1);
            if (this.getAirSupply() == -20) {
                this.setAirSupply(0);
                this.hurt(this.level().damageSources().drown(), 2.0f);
            }
        } else {
            this.setAirSupply(300);
        }
    }

    public void travel(@NotNull Vec3 vec3) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(0.01f, vec3);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.9, 0.5, 0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(vec3);
        }
    }

    public void aiStep() {
        if (!this.isInWater() && this.onGround() && this.verticalCollision) {
            this.setOnGround(false);
            this.push((this.random.nextFloat() * 2.0f - 1.0f) * 0.05f, 0.4, (this.random.nextFloat() * 2.0f - 1.0f) * 0.05f);
            this.playSound(this.type.getFlopSound(this).orElse(SoundEvents.COD_FLOP), this.getSoundVolume(), this.getVoicePitch());
        }
        super.aiStep();
    }

    public boolean isPushedByFluid() {
        return false;
    }

    @Override
    protected <E extends GeoAnimatable> PlayState animate(AnimationState<E> event) {
        AnimationProcessor.QueuedAnimation animation = event.getController().getCurrentAnimation();
        if (this.isAttacking()) {
            event.getController().setAnimation(AnimationConstants.ATTACK);
            return PlayState.CONTINUE;
        }
        if (animation != null && animation.animation().name().equals("animation.creeper.attack") && event.getController().getAnimationState().equals((Object)AnimationController.State.RUNNING)) {
            return PlayState.CONTINUE;
        }
        if (!this.isInWater()) {
            event.getController().setAnimation(AnimationConstants.FLOP);
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(AnimationConstants.SWIM);
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(AnimationConstants.IDLE);
        return PlayState.STOP;
    }
}

